function [] = draw_data(pred, y, testable)
% DRAW_DATA Plots and saves the confusion matrix for training or test set
%   pred: predicted labels
%   y: ground truth labels
%   testable: boolean flag indicating whether it's test set or not

% Uncomment and modify this section if you have a custom label mapping
% num_labels = 3;
% Map label value '3' to '0', if needed
% pred(pred == num_labels) = 0;
% y(y == num_labels) = 0;

root = find_root();  % Get the root directory

% Accuracy calculation
if y == -1.532
    % If labels are invalid (or not available), skip plotting
    disp('No labels in test set')
else
    if testable
        % If evaluating on test set
        fn = fullfile(root, 'output_bayes', 'test_Diagram');  % Output file path
        fprintf('\nTest Set Accuracy: %f\n', mean(double(pred == y)) * 100);  % Display accuracy
    else
        % If evaluating on training set
        fn = fullfile(root, 'output_bayes', 'training_Diagram');  % Output file path
        fprintf('\nTraining Set Accuracy: %f\n', mean(double(pred == y)) * 100);  % Display accuracy
    end
    
    % Draw confusion matrix chart
    figure
    cm = confusionchart(y, pred);  % Create confusion matrix chart
    cm.NormalizedValues;  % Compute normalized values for better visualization
    if testable
        cm.Title = 'Test Classification';  % Title for test set
    else
        cm.Title = 'Training Classification';  % Title for training set
    end
    cm.RowSummary = 'row-normalized';  % Normalize rows
    cm.ColumnSummary = 'column-normalized';  % Normalize columns

    drawnow  % Ensure all graphics rendering is completed before saving

    fnpng = [fn, '.png'];  % Output file name with .png extension
    print('-dpng', fnpng);  % Save figure as PNG
end

disp('Save completed');
fprintf(' %s \n', fn);  % Print saved file path
end
